package com.vmware.samples.globalview {
import com.vmware.flexutil.proxies.BaseProxy;
import com.vmware.flexutil.ServiceUtil;

/**
 * Proxy class for the GlobalService java service
 */
public class GlobalServiceProxy extends BaseProxy {
   // Service name matching the flex:remoting-destination declared in
   // main/webapp/WEB-INF/spring/bundle-context.xml
   private static const SERVICE_NAME:String = "GlobalService";

   /**
    * Create a GlobalServiceProxy with a secure channel.
    */
   public function GlobalServiceProxy() {
      // channelUri uses the Web-ContextPath defined in MANIFEST.MF
      const channelUri:String = ServiceUtil.getDefaultChannelUri(GlobalviewModule.contextPath);
      super(SERVICE_NAME, channelUri);
   }

   /**
    * Call the "setSettings" method of GlobalService.
    *
    * @param settings      The new GlobalSettings value
    * @param callBack      Optional callback method
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function setSettings(settings:GlobalSettings, callback:Function = null,
      context:Object = null):void {
      callService("setSettings", [settings], callback, context);
   }

   /**
    * Call the "getSettings" method of GlobalService.
    *
    * @param callBack      callback method used to return the result
    * @param callContext   Optional object that is passed back in the callback method
    */
   public function getSettings(callback:Function = null, context:Object = null):void {
      // This method takes no arguments
      callService("getSettings", [], callback, context);
   }
}
}